package ru.yandex.chemodan.app.docviewer.disk.resource;

import java.util.NoSuchElementException;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUrlHelper;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author akirakozov
 */
public abstract class DiskResourceId {
    public String getPrivateHash() {
        throw new NoSuchElementException();
    }

    public String getPath() {
        throw new NoSuchElementException();
    }

    public abstract DiskResourceType getType();
    public abstract String getCopyToDiskUrl(
            MpfsUrlHelper mpfsUrlHelper, PassportUidOrZero uid, Option<String> fileName, boolean publish);

    public abstract Service getService();
    public abstract String getServiceFileId();
}
