package ru.yandex.chemodan.app.docviewer.disk.resource;

import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUrlHelper;
import ru.yandex.inside.mulca.MulcaId;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.lang.Validate;

/**
 * @author akirakozov
 */
@Data
public class MailAttachmentId extends DiskResourceId {
    private final MulcaId mulcaId;
    private final String mid;

    public MailAttachmentId(MulcaId mulcaId, String mid) {
        Validate.isTrue(!mulcaId.isOnlyStid(), "Attachment id should contain part");
        this.mulcaId = mulcaId;
        this.mid = mid;
    }

    @Override
    public String getPath() {
        return "/mulca/" + mulcaId.getStid() + ":" + mulcaId.getPart();
    }

    @Override
    public DiskResourceType getType() {
        return DiskResourceType.MAIL_ATTACHMENT;
    }

    @Override
    public String getCopyToDiskUrl(
            MpfsUrlHelper mpfsUrlHelper, PassportUidOrZero uid, Option<String> fileName, boolean publish)
    {
        return mpfsUrlHelper.getAsyncCopyDefaultUrl(uid, getPath(), fileName, publish);
    }

    @Override
    public Service getService() {
        return Service.MAIL;
    }

    @Override
    public String getServiceFileId() {
        return mid + "/" + mulcaId.getPart();
    }


}
