package ru.yandex.chemodan.app.docviewer.disk.resource;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUrlHelper;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author akirakozov
 */
public class MailAttachmentId2 extends DiskResourceId {
    private final String mid;
    private final String hid;

    public MailAttachmentId2(String mid, String hid) {
        this.mid = mid;
        this.hid = hid;
    }

    @Override
    public String getPath() {
        return "/mail/file:" + mid + ":" + hid;
    }

    @Override
    public DiskResourceType getType() {
        return DiskResourceType.MAIL_ATTACHMENT;
    }

    @Override
    public String getCopyToDiskUrl(
            MpfsUrlHelper mpfsUrlHelper, PassportUidOrZero uid, Option<String> fileName, boolean publish)
    {
        return mpfsUrlHelper.getAsyncCopyDefaultUrl(uid, getPath(), fileName, publish);
    }

    @Override
    public Service getService() {
        return Service.MAIL;
    }

    @Override
    public String getServiceFileId() {
        return mid + "/" + hid;
    }
}
