package ru.yandex.chemodan.app.docviewer.disk.resource;

import java.io.File;

import org.apache.http.client.methods.HttpGet;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUrlHelper;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUtils;
import ru.yandex.chemodan.app.docviewer.utils.UriUtils;
import ru.yandex.chemodan.app.docviewer.utils.httpclient.MpfsHttpClient;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.io.http.apache.v4.ReadStringResponseHandler;

/**
 * @author metal
 */
public class WebDocumentId extends DiskResourceId {
    private final String actualUrl;
    private final MpfsHttpClient mpfsHttpClient;

    public WebDocumentId(String actualUrl, MpfsHttpClient mpfsHttpClient) {
        this.actualUrl = actualUrl;
        this.mpfsHttpClient = mpfsHttpClient;
    }

    @Override
    public DiskResourceType getType() {
        return DiskResourceType.WEB_DOCUMENT;
    }

    @Override
    public String getCopyToDiskUrl(
            MpfsUrlHelper mpfsUrlHelper, PassportUidOrZero uid, Option<String> fileName, boolean publish)
    {
        String path = makeAndGetDefaultDownloadsFolder(mpfsUrlHelper, uid)
                + fileName.getOrElse(UriUtils.getFileName(actualUrl));
        return mpfsUrlHelper.getAsyncStoreExternalUrl(uid, path, actualUrl);
    }

    @Override
    public Service getService() {
        return Service.WEB;
    }

    @Override
    public String getServiceFileId() {
        return actualUrl;
    }

    private String makeAndGetDefaultDownloadsFolder(MpfsUrlHelper mpfsUrlHelper, PassportUidOrZero uid) {
        String url = mpfsUrlHelper.getMakeSystemDirectoryUrl(uid, SystemDirectoryType.DOWNLOADS);
        String resp = ApacheHttpClientUtils
                .execute(new HttpGet(url), mpfsHttpClient, new ReadStringResponseHandler());
        return MpfsUtils.getPathFromMakeSystemDirectory(resp) + File.separator;
    }
}
