package ru.yandex.chemodan.app.docviewer.disk.resource;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.disk.mpfs.MpfsUrlHelper;
import ru.yandex.inside.mds.MdsFileKey;
import ru.yandex.inside.passport.PassportUidOrZero;

/**
 * @author akirakozov
 */
public class YaBroResourceId extends DiskResourceId {
    public static final String BROWSER_SERVICE = "browser";
    private final MdsFileKey mdsFileKey;

    public YaBroResourceId(MdsFileKey mdsFileKey) {
        this.mdsFileKey = mdsFileKey;
    }

    @Override
    public DiskResourceType getType() {
        return DiskResourceType.YA_BRO_DOCUMENT;
    }

    @Override
    public String getCopyToDiskUrl(
            MpfsUrlHelper mpfsUrlHelper, PassportUidOrZero uid, Option<String> fileName, boolean publish)
    {
        String serviceFileId = uid.toString() + ":" + mdsFileKey.serialize();
        return mpfsUrlHelper.getAsyncImportFileFromServiceUrl(uid, BROWSER_SERVICE,
                serviceFileId, fileName.get());
    }

    @Override
    public Service getService() {
        return Service.BROWSER;
    }

    @Override
    public String getServiceFileId() {
        return mdsFileKey.serialize();
    }
}
