package ru.yandex.chemodan.app.docviewer.graphite;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author akirakozov
 */
public class DvGraphiteLocalHostnameHolder {
    private static final Logger logger = LoggerFactory.getLogger(DvGraphiteLocalHostnameHolder.class);

    private static final String QLOUD_DISCOVERY_INSTANCE_VAR = "QLOUD_DISCOVERY_INSTANCE";
    private static final Option<String> QLOUD_HOST_NAME = readQloudName();

    public static Option<String> readQloudName() {
        String value = System.getenv(QLOUD_DISCOVERY_INSTANCE_VAR);
        logger.debug("Read {} variable, value: {}", QLOUD_DISCOVERY_INSTANCE_VAR, value);
        return StringUtils.notBlankO(value);
    }

    public String getHostnameForGraphite() {
        String hostname = QLOUD_HOST_NAME.isPresent() ? QLOUD_HOST_NAME.get() : HostnameUtils.localHostname();

        return hostname.replace('.', '_');
    }

    public static String getHostnameForGraphiteMetric() {
        return new DvGraphiteLocalHostnameHolder().getHostnameForGraphite();
    }

}
