package ru.yandex.chemodan.app.docviewer.graphite;

import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @author akirakozov
 */
public class EventMeterMap {
    private final ConcurrentHashMap<String, AtomicLong> map = new ConcurrentHashMap<>();

    public void incEvent(String eventName) {
        AtomicLong counter = getOrCreate(eventName);
        counter.getAndIncrement();
    }

    public Enumeration<String> getEventNames() {
        return map.keys();
    }

    public long getCounter(String eventName) {
        return map.get(eventName).get();
    }

    private AtomicLong getOrCreate(String key) {
        return map.computeIfAbsent(key, k -> new AtomicLong(0L));
    }

    @Override
    public String toString() {
        return map.toString();
    }
}
