package ru.yandex.chemodan.app.docviewer.graphite;

import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

import org.joda.time.Instant;

/**
 * @author akirakozov
 */
public class EventMinuteMeterMap {
    private final ConcurrentHashMap<Integer, EventMeterMap> map = new ConcurrentHashMap<>();

    public void incEvent(String eventName, Instant timestamp) {
        int minuteOfHour = timestamp.toDateTime().getMinuteOfHour();
        EventMeterMap eventMap = getOrCreate(minuteOfHour);
        eventMap.incEvent(eventName);
    }

    public Enumeration<Integer> getMinuteKeys() {
        return map.keys();
    }

    public EventMeterMap getEventMeterMap(int minuteOfHour) {
        return map.get(minuteOfHour);
    }

    public EventMeterMap removeEventMeterMap(int minuteOfHour) {
        return map.remove(minuteOfHour);
    }

    private EventMeterMap getOrCreate(int minuteOfHour) {
        return map.computeIfAbsent(minuteOfHour, k -> new EventMeterMap());
    }

    public void reset() {
        map.clear();
    }

    @Override
    public String toString() {
        return map.toString();
    }
}
