package ru.yandex.chemodan.app.docviewer.graphite;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.commune.alive2.location.Location;
import ru.yandex.commune.graphite.GraphiteClient;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.Version;

/**
 * @author akirakozov
 */
@Configuration
@Import({GraphiteClientContextConfiguration.class})
public class GraphiteContextConfiguration {

    @Autowired
    private Version version;
    @Autowired
    private AppName appName;

    @Autowired
    private Location location;
    @Bean
    public GraphiteTmpfsSizePusher graphiteTmpfsSizePusher(
            GraphiteClient graphiteClient)
    {
        return new GraphiteTmpfsSizePusher(
                graphiteClient,
                GraphitePrefixPathUtils.getCommonGraphitePrefix(
                        appName, "tmp", version.getProjectVersion().replace(".", "_"), getHostnameForGraphiteMetric(), location),
                FileUtils.getParentTempDir().getPath());
    }

    @Bean
    public GraphiteQueuesStatusPusher graphiteQueuesStatusPusher(
            ConfigurableApplicationContext applicationContext,
            GraphiteClient graphiteClient)
    {
        return new GraphiteQueuesStatusPusher(
                applicationContext, graphiteClient,
                GraphitePrefixPathUtils.getCommonGraphitePrefix(
                        appName, "queue", version.getProjectVersion().replace(".", "_"), getHostnameForGraphiteMetric(), location));
    }

    @Bean
    public GraphiteEventStatisticPusher graphiteEventStatisticPusher(
            GraphiteClient graphiteClient)
    {
        return new GraphiteEventStatisticPusher(
                graphiteClient,
                GraphiteEventStatisticManager.getEventMinuteMeterMap(),
                GraphitePrefixPathUtils.getCommonGraphitePrefix(
                        appName, "stage", version.getProjectVersion().replace(".", "_"), getHostnameForGraphiteMetric(), location));
    }

    private String getHostnameForGraphiteMetric() {
        return DvGraphiteLocalHostnameHolder.getHostnameForGraphiteMetric();
    }

}
