package ru.yandex.chemodan.app.docviewer.graphite;

import org.joda.time.Duration;
import org.joda.time.Instant;


/**
 * @author akirakozov
 */
public class GraphiteEventStatisticManager {
    private final static Duration MAX = Duration.standardSeconds(40);
    private final static Duration STEP = Duration.standardSeconds(10);

    private final static EventMinuteMeterMap meterMap = new EventMinuteMeterMap();

    public static EventMinuteMeterMap getEventMinuteMeterMap() {
        return meterMap;
    }

    public static void pushEventStatistic(String stageName, Duration duration, String success, Instant now) {
        String statusStageName = stageName + "." + success;
        meterMap.incEvent(statusStageName, now);

        String durationStageName = stageName + "." + calcDurationPostfix(duration);
        meterMap.incEvent(durationStageName, now);
    }

    private static String calcDurationPostfix(Duration duration) {
        if (duration.isLongerThan(MAX)) {
            return MAX.getStandardSeconds() + "_inf";
        }

        long step = STEP.getStandardSeconds();
        long lowBound = (duration.getStandardSeconds() / step) * step;
        return lowBound + "_" + (lowBound + STEP.getStandardSeconds());
    }
}
