package ru.yandex.chemodan.app.docviewer.graphite;

import java.util.Collections;
import java.util.List;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.commune.graphite.GraphiteClient;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author akirakozov
 */
public class GraphiteEventStatisticPusher extends DelayingWorkerServiceBeanSupport {
    private static final Logger logger = LoggerFactory.getLogger(GraphiteEventStatisticPusher.class);

    private final EventMinuteMeterMap meterMap;
    private final GraphiteClient graphiteClient;
    private final String graphitePathPrefix;

    public GraphiteEventStatisticPusher(GraphiteClient graphiteClient,
        EventMinuteMeterMap meterMap, String graphitePathPrefix)
    {
        this.graphiteClient = graphiteClient;
        this.meterMap = meterMap;
        this.graphitePathPrefix = graphitePathPrefix;
        setDelay(Duration.standardMinutes(1));
    }

    @Override
    protected void execute() {
        pushEventStatisticByMinute(Instant.now());
    }

    void pushEventStatisticByMinute(Instant now) {
        int curMinuteOfHour = now.toDateTime().getMinuteOfHour();
        List<Integer> minutes = Collections.list(meterMap.getMinuteKeys());
        minutes.stream().filter(minute -> curMinuteOfHour != minute).forEach(minuteOfHour -> {
            int minutesDiff = curMinuteOfHour - minuteOfHour;
            if (minutesDiff < 0) {
                minutesDiff += 60;
            }
            Instant counterTime = now.minus(Duration.standardMinutes(minutesDiff));
            pushMinuteStatistic(meterMap.removeEventMeterMap(minuteOfHour), counterTime);
        });
    }

    private void pushMinuteStatistic(EventMeterMap eventMeterMap, Instant now) {
        List<String> keys = Collections.list(eventMeterMap.getEventNames());
        keys.forEach(key -> pushEventStatistic(key, eventMeterMap.getCounter(key), now));
    }

    private void pushEventStatistic(String key, long counter, Instant now) {
        try {
            String graphitePath = graphitePathPrefix + "." + key;
            graphiteClient.spool(graphitePath, counter, now);
        } catch (Exception e) {
            logger.warn(e, e);
        }
    }
}
