package ru.yandex.chemodan.app.docviewer.graphite;

import ru.yandex.commune.alive2.location.Location;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.version.AppName;

/**
 * @author akirakozov
 */
public class GraphitePrefixPathUtils {
    private static final String GRAPHITE_PREFIX = "media.";

    public static String getCommonGraphitePrefix(AppName appName, String name, String version, String hostname,
                Location location) {

        String dcName = location.getDcName().getOrElse("unknown_dc");
        return GRAPHITE_PREFIX
                + appName.serviceName() + "."
                + appName.appName() + "."
                + name + "."
                + EnvironmentType.getActive() + "."
                + dcName + "."
                + hostname + "."
                + version;
    }

}
