package ru.yandex.chemodan.app.docviewer.graphite;

import javax.annotation.PostConstruct;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ConfigurableApplicationContext;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.docviewer.utils.scheduler.Scheduler;
import ru.yandex.commune.graphite.GraphiteClient;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.spring.ApplicationContextUtils;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author akirakozov
 */
public class GraphiteQueuesStatusPusher extends DelayingWorkerServiceBeanSupport {
    private static final Logger logger = LoggerFactory.getLogger(GraphiteQueuesStatusPusher.class);

    private final GraphiteClient graphiteClient;
    private final ConfigurableApplicationContext applicationContext;
    private final String graphitePathPrefix;

    private MapF<String, Scheduler> schedulers;

    @Override
    @Value("${graphite.queue.status.pusher.delay}")
    public void setDelay(Duration delay) {
        super.setDelay(delay);
    }

    public GraphiteQueuesStatusPusher(
            ConfigurableApplicationContext applicationContext,
            GraphiteClient graphiteClient,
            String graphitePathPrefix)
    {
        this.applicationContext = applicationContext;
        this.graphiteClient = graphiteClient;
        this.graphitePathPrefix = graphitePathPrefix;
    }

    @PostConstruct
    protected void init() {
        schedulers = ApplicationContextUtils.beansOfTypeMap(applicationContext, Scheduler.class);
    }

    @Override
    protected void execute() {
        for (String schedulerName : schedulers.keySet()) {
            try {
                pushQueueStatus(schedulerName, schedulers.getTs(schedulerName));
            } catch (Exception e) {
                logger.warn(e, e);
            }
        }
    }

    void pushQueueStatus(String schedulerName, Scheduler scheduler) {
        String graphiteCommonPath = graphitePathPrefix + "." + schedulerName;
        graphiteClient.spool(graphiteCommonPath +  ".queue_size", scheduler.getQueueLength(), Instant.now());
        graphiteClient.spool(graphiteCommonPath +  ".active_workers", scheduler.getActiveWorkers(), Instant.now());
    }

}
