package ru.yandex.chemodan.app.docviewer.graphite;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.commune.graphite.GraphiteClient;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author metal
 */
public class GraphiteTmpfsSizePusher extends DelayingWorkerServiceBeanSupport {
    private static final Logger logger = LoggerFactory.getLogger(GraphiteTmpfsSizePusher.class);

    private final String tmpfsSizeGraphitePath;

    private final GraphiteClient graphiteClient;
    private final File2 tmpfsDir;

    @Override
    @Value("${graphite.tmpfs.size.pusher.delay}")
    public void setDelay(Duration delay) {
        super.setDelay(delay);
    }

    public GraphiteTmpfsSizePusher(GraphiteClient graphiteClient, String graphitePrefix, String tmpfsDir) {
        this.graphiteClient = graphiteClient;
        this.tmpfsSizeGraphitePath = graphitePrefix;
        this.tmpfsDir = new File2(tmpfsDir);
    }

    @Override
    protected void execute() {
        try {
            pushTmpfsSize();
        } catch (Exception e) {
            logger.warn(e, e);
        }
   }

    private void pushTmpfsSize() {
        Instant now = Instant.now();
        graphiteClient.spool(tmpfsSizeGraphitePath + ".tmpfs_size_mb", tmpfsDir.usedSpaceRecursive().toMegaBytes(), now);
        graphiteClient.spool(tmpfsSizeGraphitePath + ".dv_tmp_size_mb", FileUtils.getTempFilesSize().toMegaBytes(), now);
        graphiteClient.spool(tmpfsSizeGraphitePath + ".dv_tmp_free_mb", FileUtils.getTempFreeSize().toMegaBytes(), now);
    }
}
