package ru.yandex.chemodan.app.docviewer.log;

import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.chemodan.log.TskvLogPatternLayout;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.version.AppName;

/**
 * @author akirakozov
 */
public class DocviewerLogHelper extends Log4jHelper {
    static final String eventsLogTskvName = "ru.yandex.chemodan.uploader.log.tskv.Events";

    public static void configureRootFileLogger(AppName appName) {
        rootLoggerBuilder().appName(appName).build();
        initLogger();
    }

    public static void configureAccessLogger(AppName appName) {
        accessLoggerBuilder().appName(appName).build();
    }

    public static void configureEventsLogger(AppName appName) {
        LoggerEventsRecorder.setUseTskv();

        TskvLogPatternLayout layout = new TskvLogPatternLayout(getEventsLogTskvFormat(appName),
                false,
                true,
                "\tenv=" + EnvironmentType.getActiveSecondary().getOrElse(""));
        layout.setForceEmptyRidAndYcrid(true);
        Log4jHelper.appenderBuilder()
                .appName(appName)
                .name(eventsLogTskvName)
                .postfix("-events")
                .layout(layout)
                .build();

    }

    public static void initLogger() {
        configureLogger("ru.yandex", Level.DEBUG);
        configureLogger("ru.yandex.commune.graphite", Level.WARN);
        configureLogger("ru.yandex.commune.monica", Level.WARN);

        configureLogger("com.yandex.ydb.table", Level.DEBUG);
    }

    private static String getEventsLogTskvFormat(AppName appName) {
        return "ydisk-" + appName.serviceName() + "-" + appName.appName() + "-events-log";
    }

}
