package ru.yandex.chemodan.app.docviewer.log;

import java.util.concurrent.Callable;
import java.util.function.Function;

import ru.yandex.bolts.collection.Tuple2List;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public enum DvStages {
    VALIDATE_URI("validate-uri"),
    CONVERT_STAGE("convert"),
    COPY_STAGE("copy"),
    EXTRACT_STAGE("extract"),
    SUBMIT_STAGE("submit"),
    START_STAGE("start"),
    CLEANUP_STAGE("cleanup"),
    CLEANUP_MULCA_STAGE("mulca"),
    STORE_RESULT_STAGE("store-result"),
    CHECK_SRC_FILE_STAGE("check-src-file"),
    GET_MULCA_ID("get-mulca-id"),
    SCHEDULE_CONVERT("schedule-convert"),
    UPDATE_PREVIEW_META_STAGE("update-preview-meta"),
    FORWARD_STAGE("forward"),
    FORWARD_TO_START_INTERNAL_STAGE("forward-to-start-internal"),
    RENDER("render"),
    PROCESSING_DONE("processing-done");

    private final String stageName;

    DvStages(String stageName) {
        this.stageName = stageName;
    }

    public String getName() {
        return stageName;
    }

    public <T> T log(Tuple2List<String, Object> args, Callable<T> body) {
        return log(args, body, r -> Tuple2List.tuple2List());
    }

    public <T> T log(Tuple2List<String, Object> args, Callable<T> body, Function<T, Tuple2List<String, Object>> resultMapper) {
        return LoggerEventsRecorder.logStage(this, args, body, resultMapper);
    }
}
