package ru.yandex.chemodan.app.docviewer.log;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.annotation.MonicaStaticRegistry;
import ru.yandex.misc.monica.core.blocks.InstrumentMap;
import ru.yandex.misc.monica.core.blocks.MeterMapWithDistribution;
import ru.yandex.misc.monica.core.blocks.UpdateMode;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;
import ru.yandex.misc.monica.util.measure.MeasureInfo;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public class EventsStatistic {

    private static final MapF<String, MetricName> stageMetricsCache = Cf.hashMap();

    @MonicaMetric(description = "Stages timings and error rates")
    @GroupByDefault
    private static final InstrumentMap stages = new InstrumentMap();

    @MonicaMetric(description = "Converters distribution")
    @GroupByDefault
    private static final MeterMapWithDistribution convertersDistr = new MeterMapWithDistribution();

    @MonicaMetric(description = "Converters duration distribution")
    @GroupByDefault
    private static final MeterMapWithDistribution convertersTimeDistr = new MeterMapWithDistribution();

    @MonicaMetric(description = "Converters duration with quantiles")
    @GroupByDefault
    private static final InstrumentMap converters = new InstrumentMap();

    @MonicaMetric(description = "Timings and error rates for files by extension")
    @GroupByDefault
    private static final InstrumentMap fileExtension = new InstrumentMap();

    @MonicaMetric(description = "File extension distribution")
    @GroupByDefault
    private static final MeterMapWithDistribution fileExtensionDistr = new MeterMapWithDistribution();

    @MonicaMetric(description = "File extension convert duration distribution")
    @GroupByDefault
    private static final MeterMapWithDistribution fileExtensionTimeDistr = new MeterMapWithDistribution();



    static {
        for (DvStages stage : DvStages.values()) {
            stageMetricsCache.put(stage.getName(), new MetricName(stage.getName()));
        }

        MonicaStaticRegistry.register(EventsStatistic.class, new MetricGroupName(
                "stages",
                new MetricName("dv-events"),
                "Total statistics for all stages, converters and types"));
    }

    public static void updateGlobalStageInfo(String stageName, Duration duration, boolean isSuccessful) {
        stages.update(new MeasureInfo(duration, isSuccessful), stageMetricsCache.getTs(stageName), UpdateMode.RECURSIVE);
    }

    public static void updateConverters(
            TargetType convertTargetType,
            String converter, Duration convertDuration,
            boolean isSuccessful, String fileExtension)
    {
        convertersTimeDistr.inc(convertDuration.getMillis(),
                new MetricName(converter));
        convertersDistr.inc(new MetricName(converter));
        converters.update(
                new MeasureInfo(convertDuration, isSuccessful),
                new MetricName(converter, convertTargetType.toString().toLowerCase()), UpdateMode.RECURSIVE);

        EventsStatistic.fileExtension.update(new MeasureInfo(convertDuration, isSuccessful), new MetricName(fileExtension), UpdateMode.RECURSIVE);
        fileExtensionDistr.inc(new MetricName(fileExtension));
        fileExtensionTimeDistr.inc(convertDuration.getMillis(), new MetricName(fileExtension), UpdateMode.RECURSIVE);

    }
}
