package ru.yandex.chemodan.app.docviewer.log;

import lombok.Builder;
import lombok.Data;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.dao.uris.StoredUri;

/**
 * @author akirakozov
 */
@Data
@Builder
public class StartConversionInfo {
    @Builder.Default public final Instant startTime =  Instant.now();
    public final boolean isYandex;
    public final TargetType convertTargetType;
    public final DocumentSourceInfo source;
    public final Option<StoredUri> storedUriO;
    @Builder.Default public final ListF<String> skipableContentTypes = Cf.list();
    public final boolean isExternalUrl;
    public final ActualUri actualUri;

}
