package ru.yandex.chemodan.app.docviewer.monica;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author akirakozov
 */
public class DvGraphiteMetricsRegistry {

    private ListF<Pattern2> patterns = Cf.list();

    public DvGraphiteMetricsRegistry(String patterns) {
        this.patterns = initPatterns(patterns);
    }

    private ListF<Pattern2> initPatterns(String patterns) {
        return Cf.list(StringUtils.split(patterns, ",")).map(Pattern2::compile);
    }

    public ListF<Pattern2> getPatterns() {
        return patterns;
    }

}
