package ru.yandex.chemodan.app.docviewer.monica;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.docviewer.graphite.GraphiteClientContextConfiguration;
import ru.yandex.commune.alive2.location.Location;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.commune.monica.MonicaClientBaseContextConfiguration;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.io.exec.ProcessUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.monica.MonicaConfiguration;
import ru.yandex.misc.monica.core.name.LocalMetricNamespace;
import ru.yandex.misc.version.AppName;

/**
 * @author akirakozov
 */
@Configuration
@Import({
        MonicaClientBaseContextConfiguration.class,
        MonicaDvGraphitePusherContextConfiguration.class,
        GraphiteClientContextConfiguration.class
})
public class MonicaDvContextConfiguration {

    @Bean
    public MonicaConfiguration monicaConfiguration(
            AppName appName, EnvironmentType environmentType,
            LocationResolver locationResolver)
    {
        Location location = locationResolver.resolveLocation();
        String dcName = location.getDcName().getOrElse("unknown");
        String conductorGroup = location.getGroupName().getOrElse("unknown");

        LocalMetricNamespace localMetricNamespace =
                new LocalMetricNamespace(
                        environmentType.toString().toLowerCase(),
                        appName.serviceName(),
                        appName.appName(),
                        conductorGroup,
                        dcName,
                        location.host,
                        ProcessUtils.getPid());
        return new MonicaConfiguration(localMetricNamespace) {
            protected Duration getDefaultTick() {
                return Duration.standardSeconds(5);
            }
        };
    }

    @Bean
    public MemoryUsageStatistic memoryUsageStatistic(
            @Value("${monica.enabled.memory.usage.processes}") String processesNames)
    {
        return new MemoryUsageStatistic(Cf.list(StringUtils.split(processesNames, ',')));
    }
}
