package ru.yandex.chemodan.app.docviewer.monica;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.docviewer.graphite.DvGraphiteLocalHostnameHolder;
import ru.yandex.commune.graphite.GraphiteClient;
import ru.yandex.commune.monica.pusher.graphite.GraphitePusherConfiguration;
import ru.yandex.commune.monica.pusher.graphite.MonicaGraphitePusher;
import ru.yandex.misc.monica.MonicaConfiguration;
import ru.yandex.misc.monica.core.name.NameDimension;
import ru.yandex.misc.monica.service.MonicaLocalSnapshotSupplier;
import ru.yandex.misc.version.Version;

/**
 * @author akirakozov
 */
@Configuration
public class MonicaDvGraphitePusherContextConfiguration {
    @Bean
    public MonicaGraphitePusher monicaGraphitePusher(
            MonicaConfiguration monicaConfiguration,
            MonicaLocalSnapshotSupplier monicaLocalSnapshotSupplier,
            GraphiteClient graphiteClient,
            Version version,
            @Value("${monica.enabled.metrics.patterns}")
            String metricsPatterns)
    {
        String service = monicaConfiguration.localNamespace().value(NameDimension.SERVICE_NAME);
        String appName = monicaConfiguration.localNamespace().value(NameDimension.APP_NAME);

        GraphitePusherConfiguration configuration = new DvGraphitePusherConfiguration(
                Duration.standardSeconds(5),
                consGraphitePathPrefix(service, appName),
                new DvGraphiteMetricsRegistry(metricsPatterns),
                version.getProjectVersion(),
                DvGraphiteLocalHostnameHolder.getHostnameForGraphiteMetric());

        MonicaGraphitePusher pusher = new MonicaGraphitePusher(configuration, graphiteClient);

        monicaLocalSnapshotSupplier.registerConsumer(pusher);

        return pusher;
    }

    public static String consGraphitePathPrefix(String service, String appName) {
        return "media." + service + "." + appName + ".monica";
    }

}
