package ru.yandex.chemodan.app.docviewer.states;

import ru.yandex.bolts.collection.Option;

/**
 * @author akirakozov
 */
@SuppressWarnings("serial")
public class ConvertUserException extends UserException {
    private final String converterName;

    public ConvertUserException(UserException ue, String converterName) {
        super(ue.getErrorCode(), ue.getMessage(), Option.ofNullable(ue.getCause()));
        this.converterName = converterName;
    }

    public ConvertUserException(RuntimeException e, String converterName) {
        super(ErrorCode.UNKNOWN_CONVERT_ERROR, e);
        this.converterName = converterName;
    }

    public String getConverterName() {
        return converterName;
    }

    public static ConvertUserException fromRuntimeException(RuntimeException e, String converterName) {
        if (e instanceof UserException) {
            return new ConvertUserException((UserException) e, converterName);
        } else {
            return new ConvertUserException(e, converterName);
        }
    }
}
