package ru.yandex.chemodan.app.docviewer.states;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.enums.EnumResolver;

public enum ErrorCode {
    CONVERT_TIMEOUT,
    FILE_IS_EMPTY,
    FILE_IS_PASSWORD_PROTECTED,
    UNSUPPORTED_PASSWORD_PROTECTED,
    FILE_IS_FORBIDDEN,
    FILE_NOT_FOUND,
    FILE_TOO_BIG,
    ARCHIVE_TOO_BIG,
    UNABLE_TO_RETRIEVE_FILE,
    UNABLE_TO_RETRIEVE_FILE_NO_LENGTH_SPECIFIED,
    UNKNOWN_CONVERT_ERROR,
    UNKNOWN_COPY_ERROR,
    TOO_MANY_RETRIES,
    UNSUPPORTED_CONVERTION,
    UNSUPPORTED_SOURCE_TYPE,
    ARCHIVE_EXTRACTION_ERROR,
    ;

    private static final SetF<ErrorCode> PERMANENT_CONVERT_ERRORS = Cf.hashSet(
            FILE_IS_EMPTY,
            UNSUPPORTED_PASSWORD_PROTECTED,
            TOO_MANY_RETRIES,
            UNSUPPORTED_CONVERTION,
            UNSUPPORTED_SOURCE_TYPE);

    private static final SetF<ErrorCode> NOT_IMPORTANT_ERRORS = Cf.hashSet(
            FILE_IS_EMPTY,
            FILE_IS_PASSWORD_PROTECTED,
            UNSUPPORTED_PASSWORD_PROTECTED,
            FILE_IS_FORBIDDEN,
            FILE_TOO_BIG,
            ARCHIVE_TOO_BIG,
            UNSUPPORTED_CONVERTION,
            UNSUPPORTED_SOURCE_TYPE,
            UNABLE_TO_RETRIEVE_FILE_NO_LENGTH_SPECIFIED);

    private static final EnumResolver<ErrorCode> resolver = new EnumResolver<>(ErrorCode.class);

    public static ErrorCode valueOf(String str, ErrorCode getOrElse) {
        return resolver.valueOfO(str).getOrElse(getOrElse);
    }

    public static boolean isPermanentConvertError(ErrorCode err) {
        return PERMANENT_CONVERT_ERRORS.containsTs(err);
    }

    public static boolean isNotImportantError(ErrorCode err) {
        return NOT_IMPORTANT_ERRORS.containsTs(err);
    }

}
