package ru.yandex.chemodan.app.docviewer.states;

import lombok.Builder;
import lombok.Data;

import ru.yandex.bolts.collection.Option;

/**
 * @author ssytnik
 */
@SuppressWarnings("serial")
@Data
public class FileTooBigUserException extends UserException {
    @Builder.Default private Option<Long> actualLength = Option.empty();
    private final long maxLength;
    private final String mimeType;

    @Builder
    public FileTooBigUserException(boolean isArchive, String mimeType, Option<Long> actualLength, long maxLength) {
        super(isArchive ? ErrorCode.ARCHIVE_TOO_BIG : ErrorCode.FILE_TOO_BIG);
        this.actualLength = actualLength;
        this.maxLength = maxLength;
        this.mimeType = mimeType;
    }
}
