package ru.yandex.chemodan.app.docviewer.states;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.convert.MimeDetector;
import ru.yandex.misc.dataSize.DataSize;

public interface MaxFileSizeChecker {

    default void check(long actualLength, String mimeType) {
        DataSize maxLength = getMaxFileLength(mimeType);

        if (actualLength > maxLength.toBytes()) {
            throw FileTooBigUserException.builder()
                    .isArchive(MimeDetector.isArchive(mimeType))
                    .actualLength(Option.of(actualLength))
                    .mimeType(mimeType)
                    .maxLength(maxLength.toBytes()).build();
        }
    }


    DataSize getMaxFileLength(String mimeType);

    DataSize getMaxArchiveLength();
}
