package ru.yandex.chemodan.app.docviewer.states;

import ru.yandex.bolts.collection.Option;

/**
 * @author ssytnik
 */
@SuppressWarnings("serial")
public class PasswordProtectedException extends UserException {
    private final Option<String> errorArchivePath;


    private PasswordProtectedException(Option<String> errorArchivePath, ErrorCode errorCode) {
        super(errorCode);
        this.errorArchivePath = errorArchivePath;
    }

    private PasswordProtectedException(Option<String> errorArchivePath, ErrorCode errorCode, Throwable exc) {
        super(errorCode, exc);
        this.errorArchivePath = errorArchivePath;
    }


    public static PasswordProtectedException atCopy(String errorArchivePath) {
        return new PasswordProtectedException(Option.of(errorArchivePath), ErrorCode.FILE_IS_PASSWORD_PROTECTED);
    }

    public static PasswordProtectedException atConvert() {
        return new PasswordProtectedException(Option.empty(), ErrorCode.FILE_IS_PASSWORD_PROTECTED);
    }

    public static PasswordProtectedException atConvert(Throwable exc) {
        return new PasswordProtectedException(Option.empty(), ErrorCode.FILE_IS_PASSWORD_PROTECTED, exc);
    }

    public static PasswordProtectedException atConvertUnsupported(Throwable exc) {
        return new PasswordProtectedException(Option.empty(), ErrorCode.UNSUPPORTED_PASSWORD_PROTECTED, exc);
    }


    public Option<String> getErrorArchivePath() {
        return errorArchivePath;
    }

    @Override
    public String getMessage() {
        return super.getMessage() +
                (errorArchivePath.isPresent() ? " @ '" + errorArchivePath.get() + "'" : "");
    }
}
