package ru.yandex.chemodan.app.docviewer.states;

public enum State {
    NOT_STARTED(true),
    COPYING(true),
    COPY_ERROR(false),
    COPIED(false),
    NOT_FOUND(false),
    CONVERTING(true),
    CONVERTING_ERROR(false),
    AVAILABLE(false),
    ;

    private final boolean subjectTochange;

    State(final boolean subjectTochange) {
        this.subjectTochange = subjectTochange;
    }

    public boolean isSubjectTochange() {
        return subjectTochange;
    }

    public boolean isCopyingDone() {
        return !subjectTochange || this == CONVERTING;
    }
}
