package ru.yandex.chemodan.app.docviewer.states;

import ru.yandex.bolts.function.Function0V;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;

/**
 * @author akirakozov
 */
public class StateListenerManager implements StateListenerNotifier {
    private final StateListenerPool<String, Function0V> fileStateListenerPool = new StateListenerPool<>();

    private final StateListenerPool<ActualUri, Function0V> uriStateListenerPool = new StateListenerPool<>();

    @Override
    public void onStateChange(String fileId) {
        fileStateListenerPool.callAllListeners(fileId);
    }

    @Override
    public void onStateChange(ActualUri uri) {
        uriStateListenerPool.callAllListeners(uri);
    }

    public void addUriListener(ActualUri uri, Function0V listener) {
        uriStateListenerPool.addStateListener(uri, listener);
    }

    public void addFileListener(String fileId, Function0V listener) {
        fileStateListenerPool.addStateListener(fileId, listener);
    }

    public void removeUriListener(ActualUri uri, Function0V listener) {
        uriStateListenerPool.removeStateListener(uri, listener);
    }

    public void removeFileListener(String fileId, Function0V listener) {
        fileStateListenerPool.addStateListener(fileId, listener);
    }

}
