package ru.yandex.chemodan.app.docviewer.states;

import javax.annotation.concurrent.GuardedBy;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.bolts.function.Function1B;

/**
 * @author akirakozov
 */
public class StateListenerPool<K, V extends Function0V> {
    @GuardedBy("this")
    private final MapF<K, ListF<V>> stateListeners = Cf.hashMap();

    public synchronized void addStateListener(K stateKey, V callback) {
        stateListeners.put(stateKey,
                stateListeners.getOrElse(stateKey, Cf.list()).plus1(callback));
    }

    public synchronized void addStateListeners(K stateKey, ListF<V> callbacks) {
        if (callbacks.isNotEmpty()) {
            stateListeners.put(stateKey,
                    stateListeners.getOrElse(stateKey, Cf.list()).plus(callbacks));
        }
    }

    public synchronized ListF<V> getStateListeners(K stateKey) {
        return stateListeners.getOrElse(stateKey, Cf.list());
    }

    public synchronized void removeStateListener(K stateKey, V callback) {
        Option<ListF<V>> callbacks = stateListeners.getO(stateKey);
        if (callbacks.isPresent()) {
            stateListeners.put(stateKey, callbacks.get().filter(Function1B.equalsF(callback).notF()));
        }
    }

    public synchronized void callAllListeners(K stateKey) {
        Option<ListF<V>> callbacks = stateListeners.getO(stateKey);
        if (callbacks.isPresent()) {
            for (V callback : callbacks.get()) {
                callback.apply();
            }
        }
    }

}
