package ru.yandex.chemodan.app.docviewer.states;

import org.dom4j.Element;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.convert.ConvertArgs;
import ru.yandex.chemodan.app.docviewer.convert.TargetType;
import ru.yandex.chemodan.app.docviewer.convert.result.ExConvertResultInfo;
import ru.yandex.chemodan.app.docviewer.copy.ActualUri;
import ru.yandex.chemodan.app.docviewer.copy.CopiedFileInfo;
import ru.yandex.chemodan.app.docviewer.copy.DocumentSourceInfo;
import ru.yandex.chemodan.app.docviewer.storages.FileLink;
import ru.yandex.inside.passport.PassportUidOrZero;
import ru.yandex.misc.io.file.File2;

public interface StateMachine {

    Option<String> getFileId(ActualUri uri);

    Element getInfo(ActualUri uri, String sessionId);

    Element getInfo(PassportUidOrZero uid, String fileId, String sessionId);

    State getState(ActualUri uri, TargetType convertTargetType);

    State getState(PassportUidOrZero uid, String fileId, TargetType convertTargetType);

    void onConvertBegin(String fileId, TargetType convertTargetType);

    void onConvertDone(ConvertArgs convertArgs, FileLink resultFileLink, ExConvertResultInfo result, Option<String> password);

    void onConvertError(ConvertArgs args, Exception exc);

    void onCopyBegin(ActualUri uri);

    boolean onCopyDone(CopiedFileInfo info, String sessionId);

    void onCopyError(ActualUri uri, Exception exc);

    /**
     * @param taskSource
     *            task source identification for logging and debug purposes,
     *            like "/start" or "/previewurl" or "JUnit test"
     */
    boolean onStart(DocumentSourceInfo source, String taskSource,
            Option<String> contentType, TargetType targetType,
            String sessionId, ListF<String> skipableContentTypes, Instant startTime, boolean forwarded);

    String onSubmit(PassportUidOrZero uid, String contentType, File2 localCopy,
            TargetType convertTargetType, Instant totalStart);
}
