package ru.yandex.chemodan.app.docviewer.states;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

@Component
public class UserErrorReultsChecker {

    private final static Logger logger = LoggerFactory.getLogger(UserErrorReultsChecker.class);

    @Value("${convert.max.retries.delay}")
    private Duration delayBetweenRetries = Duration.standardMinutes(30);
    @Value("${convert.max.retries.count}")
    private int maxRetriesCount = 3;

    public boolean notAllowed(Option<ErrorCode> errorCode, Instant lastAccess) {
        if (errorCode.isSome(ErrorCode.TOO_MANY_RETRIES) &&
                lastAccess.plus(delayBetweenRetries).isAfter(Instant.now()))
        {
            logger.warn("Skip exec because: {}, {}", errorCode, lastAccess);
            return true;
        }
        return false;
    }

    public boolean notAllowed(int errorsCount, Instant lastAccess) {
        if (errorsCount >= maxRetriesCount &&
                lastAccess.plus(delayBetweenRetries).isAfter(Instant.now())) {
            logger.warn("Skip exec because: {}, {}", maxRetriesCount, lastAccess);
            return true;
        } else {
            return false;
        }
    }

}
