package ru.yandex.chemodan.app.docviewer.states;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;

import ru.yandex.misc.lang.Validate;

/**
 * XXX sort out 'message' and 'causedByList', then probably fix
 * {@link ConvertUserException#ConvertUserException(UserException, String)}
 * which calls ctor with list but is intended to call ctor with Throwable
 */
@SuppressWarnings("serial")
public class UserException extends RuntimeException {

    private final List<? extends Throwable> causedByList;

    private final ErrorCode errorCode;


    public UserException(ErrorCode errorCode) {
        super(errorCode.name());
        this.errorCode = errorCode;
        this.causedByList = null;
    }

    public UserException(ErrorCode errorCode, String message) {
        this(errorCode, message, Collections.emptyList());
    }

    public UserException(ErrorCode errorCode, String message, List<? extends Throwable> causedByList) {
        super(message);
        this.errorCode = errorCode;
        this.causedByList = causedByList;
    }

    public UserException(ErrorCode errorCode, Throwable exc) {
        super("Error: " + errorCode.name() + ", " + exc.getMessage(), exc);
        this.errorCode = errorCode;
        this.causedByList = null;
    }

    public ErrorCode getErrorCode() {
        return errorCode;
    }

    public void printStackTrace(PrintWriter s) {
        if (causedByList == null || causedByList.size() == 0) {
            super.printStackTrace(s);
            return;
        }

        synchronized (s) {
            s.println(this);
            StackTraceElement[] trace = getStackTrace();
            for (StackTraceElement element : trace) {
                s.println("\tat " + element);
            }

            printStackTraceAsCause(s, trace, causedByList);
        }
    }

    private static void printStackTraceAsCause(PrintWriter s, StackTraceElement[] causedTrace,
            Throwable causedBy)
    {
        StackTraceElement[] trace = causedBy.getStackTrace();
        int m = trace.length - 1, n = causedTrace.length - 1;
        while (m >= 0 && n >= 0 && trace[m].equals(causedTrace[n])) {
            m--;
            n--;
        }
        int framesInCommon = trace.length - 1 - m;

        s.println("Caused by: " + causedBy);
        for (int i = 0; i <= m; i++) {
            s.println("\tat " + trace[i]);
        }
        if (framesInCommon != 0) {
            s.println("\t... " + framesInCommon + " more");
        }

        Throwable ourCause = causedBy.getCause();
        if (ourCause != null) {
            printStackTraceAsCause(s, trace, ourCause);
        }
    }

    private static void printStackTraceAsCause(PrintWriter s, StackTraceElement[] causedTrace,
            List<? extends Throwable> causedByList)
    {
        Validate.notNull(causedByList, "causedByList is null");

        int counter = 0;
        for (Throwable causedBy : causedByList) {
            StackTraceElement[] trace = causedBy.getStackTrace();
            int m = trace.length - 1, n = causedTrace.length - 1;
            while (m >= 0 && n >= 0 && trace[m].equals(causedTrace[n])) {
                m--;
                n--;
            }
            int framesInCommon = trace.length - 1 - m;

            s.println("Exception #" + (++counter) + " was: " + causedBy);
            for (int i = 0; i <= m; i++) {
                s.println("\tat " + trace[i]);
            }
            if (framesInCommon != 0) {
                s.println("\t... " + framesInCommon + " more");
            }

            Throwable ourCause = causedBy.getCause();
            if (ourCause != null) {
                printStackTraceAsCause(s, trace, ourCause);
            }
        }
    }

}
