package ru.yandex.chemodan.app.docviewer.storages;

import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.docviewer.utils.FileUtils;
import ru.yandex.misc.io.file.File2;

public abstract class AbstractFileStorage implements FileStorage {

    @Override
    public File2 getAsTempFile(FileLink fileLink) {
        return FileUtils.createTempFile("file", ".tmp", AbstractFileStorage.this.get(fileLink));
    }

    @Override
    public void withTempFile(FileLink fileLink, Function1V<File2> handler) {
        FileUtils.withTemporaryFile("file", ".tmp", AbstractFileStorage.this.get(fileLink), handler);
    }

}
