package ru.yandex.chemodan.app.docviewer.storages.fsstorage;

import java.io.File;

import lombok.Data;

import ru.yandex.chemodan.app.docviewer.storages.FileLink;

@SuppressWarnings("serial")
@Data
public class FileSystemFileLink implements FileLink {

    private final String absolutePath;

    public FileSystemFileLink(File file) {
        this.absolutePath = file.getAbsolutePath();
    }

    public FileSystemFileLink(String absolutePath) {
        this.absolutePath = new File(absolutePath).getAbsolutePath();
    }

    public String getAbsolutePath() {
        return absolutePath;
    }

    public File getFile() {
        return new File(absolutePath);
    }

    @Override
    public String toString() {
        return getSerializedPath();
    }

    @Override
    public String getSerializedPath() {
        return absolutePath;
    }
}
