package ru.yandex.chemodan.app.docviewer.storages.mulca;

import lombok.Data;

import ru.yandex.chemodan.app.docviewer.storages.FileLink;

@SuppressWarnings("serial")
@Data
public class MulcaFileLink implements FileLink {
    private final String mulcaId;

    public MulcaFileLink(String mulcaId) {
        this.mulcaId = mulcaId;
    }

    String getMulcaId() {
        return mulcaId;
    }

    public String toString() {
        return getSerializedPath();
    }

    @Override
    public String getSerializedPath() {
        return MulcaFileStorage.SCHEMA + getMulcaId();
    }
}
