package ru.yandex.chemodan.app.docviewer.utils;

import java.util.concurrent.atomic.AtomicLong;

import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

@ManagedResource
public abstract class AbstractCache {

    private final AtomicLong cacheCalls = new AtomicLong(0);

    private final AtomicLong cacheMisses = new AtomicLong(0);

    @ManagedMetric(metricType = MetricType.COUNTER)
    public long getCacheCalls() {
        return cacheCalls.get();
    }

    @ManagedMetric(metricType = MetricType.COUNTER)
    public long getCacheHits() {
        final long misses = cacheMisses.get();
        final long calls = cacheCalls.get();
        return calls - misses;
    }

    @ManagedMetric(metricType = MetricType.COUNTER)
    public long getCacheMisses() {
        return cacheMisses.get();
    }

    @ManagedMetric(metricType = MetricType.GAUGE)
    public int getCacheRatio() {
        final long misses = cacheMisses.get();
        final long calls = cacheCalls.get();
        if (calls == 0)
            return 0;

        return (int) (100 * ((float) (calls - misses) / calls));
    }

    protected void onCacheCall() {
        cacheCalls.incrementAndGet();
    }

    protected void onCacheMiss() {
        cacheMisses.incrementAndGet();
    }
}
