package ru.yandex.chemodan.app.docviewer.utils;

import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public abstract class AbstractPoolBasedBean {

    @ManagedOperation
    public void addObject() throws Exception {
        getObjectPool().addObject();
    }

    @ManagedOperation
    public void clear() {
        getObjectPool().clear();
    }

    @ManagedOperation
    public void evict() throws Exception {
        getObjectPool().evict();
    }

    @ManagedAttribute
    public boolean getLifo() {
        return getObjectPool().getLifo();
    }

    @ManagedAttribute
    public int getMaxActive() {
        return getObjectPool().getMaxTotal();
    }

    @ManagedAttribute
    public int getMaxIdle() {
        return getObjectPool().getMaxIdle();
    }

    @ManagedAttribute
    public long getMaxWait() {
        return getObjectPool().getMaxWaitMillis();
    }

    public long getMinEvictableIdleTimeMillis() {
        return getObjectPool().getMinEvictableIdleTimeMillis();
    }

    @ManagedAttribute
    public int getMinIdle() {
        return getObjectPool().getMinIdle();
    }

    @ManagedMetric
    public int getNumActive() {
        return getObjectPool().getNumActive();
    }

    @ManagedMetric
    public int getNumIdle() {
        return getObjectPool().getNumIdle();
    }

    @ManagedAttribute
    public int getNumTestsPerEvictionRun() {
        return getObjectPool().getNumTestsPerEvictionRun();
    }

    protected abstract GenericObjectPool getObjectPool();

    @ManagedAttribute
    public long getSoftMinEvictableIdleTimeMillis() {
        return getObjectPool().getSoftMinEvictableIdleTimeMillis();
    }

    @ManagedAttribute
    public boolean getTestOnBorrow() {
        return getObjectPool().getTestOnBorrow();
    }

    @ManagedAttribute
    public boolean getTestOnReturn() {
        return getObjectPool().getTestOnReturn();
    }

    @ManagedAttribute
    public boolean getTestWhileIdle() {
        return getObjectPool().getTestWhileIdle();
    }

    @ManagedAttribute
    public long getTimeBetweenEvictionRunsMillis() {
        return getObjectPool().getTimeBetweenEvictionRunsMillis();
    }

    @ManagedAttribute
    public boolean getWhenExhaustedAction() {
        return getObjectPool().getBlockWhenExhausted();
    }

    @ManagedAttribute
    public void setLifo(boolean lifo) {
        getObjectPool().setLifo(lifo);
    }

    @ManagedAttribute
    public void setMaxActive(int maxActive) {
        getObjectPool().setMaxTotal(maxActive);
    }

    @ManagedAttribute
    public void setMaxIdle(int maxIdle) {
        getObjectPool().setMaxIdle(maxIdle);
    }

    @ManagedAttribute
    public void setMaxWait(long maxWait) {
        getObjectPool().setMaxWaitMillis(maxWait);
    }

    @ManagedAttribute
    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        getObjectPool().setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    @ManagedAttribute
    public void setMinIdle(int minIdle) {
        getObjectPool().setMinIdle(minIdle);
    }

    @ManagedAttribute
    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        getObjectPool().setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    @ManagedAttribute
    public void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        getObjectPool().setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis);
    }

    @ManagedAttribute
    public void setTestOnBorrow(boolean testOnBorrow) {
        getObjectPool().setTestOnBorrow(testOnBorrow);
    }

    @ManagedAttribute
    public void setTestOnReturn(boolean testOnReturn) {
        getObjectPool().setTestOnReturn(testOnReturn);
    }

    @ManagedAttribute
    public void setTestWhileIdle(boolean testWhileIdle) {
        getObjectPool().setTestWhileIdle(testWhileIdle);
    }

    @ManagedAttribute
    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        getObjectPool().setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    @ManagedAttribute
    public void setWhenExhaustedAction(boolean blockWhenExhausted) {
        getObjectPool().setBlockWhenExhausted(blockWhenExhausted);
    }

}
