package ru.yandex.chemodan.app.docviewer.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import ru.yandex.misc.io.OutputStreamSource;

public class ByteArrayOutputStreamSource extends OutputStreamSource {
    private byte[] array;

    public byte[] getByteArray() {
        return array;
    }

    @Override
    public OutputStream getOutput() {
        return new ByteArrayOutputStream() {
            @Override
            public void close() throws IOException {
                super.close();
                array = this.toByteArray();
            }
        };
    }
}
