package ru.yandex.chemodan.app.docviewer.utils;

import java.util.Objects;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;

/**
 * @author akirakozov
 * @author ssytnik
 */
public class DimensionO {
    public static final DimensionO WIDTH_900 = cons(900);
    public static final DimensionO WIDTH_1024 = cons(1024);
    public static final DimensionO NONE = new DimensionO(Option.empty(), Option.empty());

    public final Option<Integer> width;
    public final Option<Integer> height;


    public DimensionO(Option<Integer> width, Option<Integer> height) {
        this.width = width;
        this.height = height;
    }

    public boolean hasWidthOrHeight() {
        return width.isPresent() || height.isPresent();
    }


    @Override
    public String toString() {
        return toString("?");
    }

    public String toString(String noneString) {
        return
                width.map(Cf.Integer.toStringF()).getOrElse(noneString) + "x" +
                height.map(Cf.Integer.toStringF()).getOrElse(noneString);
    }


    public static DimensionO cons(int width) {
        return new DimensionO(toOption(width), Option.empty());
    }

    public static DimensionO cons(int width, int height) {
        return new DimensionO(toOption(width), toOption(height));
    }

    public static DimensionO consW(int width) {
        return new DimensionO(toOption(width), Option.empty());
    }

    public static DimensionO consH(int height) {
        return new DimensionO(Option.empty(), toOption(height));
    }

    private static Option<Integer> toOption(int value) {
        return Option.when(value != Integer.MAX_VALUE, value);
    }

    private static Option<Integer> parseOneDim(String value, String noneString) {
        return value.equals(noneString) ? Option.empty() : Option.of(Integer.parseInt(value));
    }

    public static DimensionO parse(String value, String noneString) {
        String[] parts = value.split("x");
        return new DimensionO(
                parseOneDim(parts[0], noneString),
                parseOneDim(parts[1], noneString));
    }

    public DimensionO map(Function<Integer, Integer> function) {
        return new DimensionO(width.map(function), height.map(function));
    }

    @Override
    public int hashCode() {
        return Objects.hash(width, height);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DimensionO) {
            DimensionO that = (DimensionO)obj;
            return Objects.equals(this.width, that.width)
                    && Objects.equals(this.height, that.height);
        } else {
            return false;
        }
    }
}
