package ru.yandex.chemodan.app.docviewer.utils;

import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.annotation.MonicaStaticRegistry;
import ru.yandex.misc.monica.core.blocks.MeterMapWithDistribution;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author Vsevolod Tolstopyatov (qwwdfsad)
 */
public final class DownloadRateInstrumentation {
    private DownloadRateInstrumentation() {
    }

    @MonicaMetric
    @GroupByDefault
    public static final MeterMapWithDistribution downloadRateMetric = new MeterMapWithDistribution();

    static {
        MonicaStaticRegistry.register(DownloadRateInstrumentation.class,
                new MetricGroupName(
                        "download-rate",
                        new MetricName("download-rate"),
                        "Downloading rates in bytes/sec"));
    }

}
