package ru.yandex.chemodan.app.docviewer.utils;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.io.exec.ExecResult;
import ru.yandex.misc.io.exec.ExecUtils;

/**
 * @author akirakozov
 */
public class ExecUtils2 {
    private static final Logger logger = LoggerFactory.getLogger(ExecUtils2.class);

    public static ExecResult runScript(ListF<String> cmd) {
        return runScript(cmd, true);
    }

    public static ExecResult runScript(ListF<String> cmd, boolean printResult) {
        logger.debug("run with parameters: {}", StringUtils.join(cmd, " "));
        ExecResult result = ExecUtils.executeGrabbingOutput(cmd);
        if (printResult) {
            logger.debug("result: {}", result.getOutput());
        }
        return result;
    }
}
