package ru.yandex.chemodan.app.docviewer.utils;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.misc.io.file.File2;

/**
 * File + flag indicating whether it can be deleted
 * Not thread-safe
 * @author ssytnik
 */
@Data
@AllArgsConstructor
public class FileCopy {
    private final File2 file;
    private final boolean canDelete;

    public FileCopy(File2 file) {
        this(file, true);
    }

    public void deleteFileIfPossible() {
        if (canDelete) {
            file.deleteRecursiveQuietly();
        }
    }
}
