package ru.yandex.chemodan.app.docviewer.utils;

import lombok.AllArgsConstructor;
import lombok.Data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.misc.io.file.File2;

/**
 * @author ssytnik
 */
@Data
@AllArgsConstructor
public class FileList {

    private final File2 fileOrFolder;

    public ListF<File2> getFiles() {
        if (fileOrFolder.isRegular()) {
            return Cf.list(fileOrFolder);
        } else if (fileOrFolder.isDirectory()) {
            return fileOrFolder.listRegularFiles();
        } else {
            throw new IllegalStateException("wrong file: " + fileOrFolder);
        }
    }
}
