package ru.yandex.chemodan.app.docviewer.utils;

import java.util.stream.Collectors;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.file.File2;

public class ImageFileList {

    public static ListF<File2> getFiles(Option<FileList> fileList) {
        if (!fileList.isPresent()) {
            return Cf.list();
        }
        if (!fileList.get().getFileOrFolder().exists()) {
            return Cf.list();
        }
        return Cf.toList(fileList.get().getFiles().stream()
                .filter(file -> file.isRegular() && file.getFile().canRead())
                .filter(file -> !file.getName().endsWith(".htm") || !file.getName().endsWith(".html"))
                .collect(Collectors.toList()));
    }

    public static void deleteIfEmpty(Option<FileList> fileList) {
        fileList.ifPresent(f -> {
            if (getFiles(fileList).isEmpty()) {
                f.getFileOrFolder().deleteRecursiveQuietly();
            }
        });
    }

    public static void deleteIfEmpty(File2 temporaryImageDirectory) {
        deleteIfEmpty(Option.of(new FileList(temporaryImageDirectory)));
    }

    public static void delete(Option<FileList> images) {
        images.ifPresent(f -> f.getFileOrFolder().deleteRecursiveQuietly());
    }
}
