package ru.yandex.chemodan.app.docviewer.utils;

import java.awt.image.RenderedImage;
import java.io.IOException;

import javax.imageio.ImageIO;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.image.ImageFormat;
import ru.yandex.misc.io.InputStreamSource;
import ru.yandex.misc.io.InputStreamSourceUtils;
import ru.yandex.misc.io.InputStreamX;
import ru.yandex.misc.io.IoFunction;
import ru.yandex.misc.io.IoUtils;
import ru.yandex.misc.io.OutputStreamSource;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.file.FileInputStreamSource;
import ru.yandex.misc.io.url.UrlInputStreamSource;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.lang.Validate;

/**
 * @author vlsergey
 * @author ssytnik
 */
public class ImageUtils {

    private static final ListF<String> WRITER_FORMAT_NAMES =
            Cf.x(ImageIO.getWriterFormatNames()).map(Cf.String.toLowerCaseF());


    public static RenderedImage read(InputStreamSource source) {
        try {
            if (source instanceof FileInputStreamSource) {
                return ImageIO.read(((FileInputStreamSource) source).getFile());
            }

            if (source instanceof UrlInputStreamSource) {
                return ImageIO.read(((UrlInputStreamSource) source).getUrl());
            }

            return source.readX((IoFunction<InputStreamX, RenderedImage>) ImageIO::read);
        } catch (IOException exc) {
            throw IoUtils.translate(exc);
        }
    }



    public static void write(final RenderedImage image, final ImageFormat toFormat, OutputStreamSource result) {
        Validate.in(toFormat.getExtension(), WRITER_FORMAT_NAMES);

        // TODO consistency with read(): separate cases for File-/UrlInputStreamSource needed ?

        result.write(a -> Check.isTrue(ImageIO.write(image, toFormat.getExtension(), a)));
    }

    public static void convert(InputStreamSource source, ImageFormat toFormat, OutputStreamSource result) {
        write(read(source), toFormat, result);
    }

    public static void convertInPlace(File2 file, ImageFormat toFormat) {
        InputStreamSource iss = InputStreamSourceUtils.bytes(file.readBytes());
        convert(iss, toFormat, file.asOutputStreamTool());
    }

}
