package ru.yandex.chemodan.app.docviewer.utils;

import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.version.AppName;

/**
 * Copy-paste from disk-apps
 * @author metal
 */
public class MaintenanceFileChecker {
    private static final String MAINTENANCE_FILE_PATH_TEMPLATE = "/var/lib/yandex/%s/%s/maintenance.file";

    private final File2 file;

    public MaintenanceFileChecker(AppName appName) {
        this.file = new File2(String.format(MAINTENANCE_FILE_PATH_TEMPLATE, appName.serviceName(), appName.appName()));
    }

    public MaintenanceFileChecker(File2 file) {
        this.file = file;
    }

    public boolean exists() {
        return file.exists();
    }
}
