package ru.yandex.chemodan.app.docviewer.utils;

import javax.mail.internet.MimeUtility;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;

/**
 * @author ssytnik
 */
public class MimeUtils {

    private static final MapF<String, String> extensionByMediaType =
            Cf.map("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx")
                    .plus1("application/vnd.ms-excel", "xls")
                    .plus1("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx")
                    .plus1("application/msword", "doc")
                    .plus1("application/pdf", "pdf")
                    .plus1("image/jpeg", "jpeg")
                    .plus1("application/rtf", "rtf")
                    .plus1("image/tiff", "tiff")
                    .plus1("application/vnd.ms-powerpoint", "ppt")
                    .plus1("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx")
                    .plus1("text/plain", "txt")
                    .plus1("application/zip", "archive")
                    .plus1("application/x-rar", "archive")
                    .plus1("application/x-tar", "archive")
                    .plus1("application/x-gzip", "archive")
                    .plus1("application/x-bzip", "archive")
                    .plus1("application/x-bzip2", "archive")
                    .plus1("archive/x-sevenzip-supported", "archive");


    public static String detectExtension(String mediaType) {
        return extensionByMediaType.getOrElse(mediaType, "other");
    }

    /**
     * Estimation is very approximate
    * @see MimeUtility#decode(java.io.InputStream, String)
    */
    public static long getEstimatedFileLength(long contentLength, String mimeEncoding) {
        return mimeEncoding.equalsIgnoreCase("base64") ? contentLength * 3 / 4 : contentLength;
    }

}
