package ru.yandex.chemodan.app.docviewer.utils;

import org.apache.poi.hpsf.SummaryInformation;

import ru.yandex.chemodan.app.docviewer.convert.DocumentProperties;

public class OleUtils {

    public static DocumentProperties getDocumentProperties(SummaryInformation info) {
        DocumentProperties properties = DocumentProperties.EMPTY;
        if (info != null) {
            properties = properties.withProperty(DocumentProperties.AUTHOR, info.getAuthor());
            properties = properties.withProperty(DocumentProperties.COMMENTS, info.getComments());
            properties = properties.withProperty(DocumentProperties.KEYWORDS, info.getKeywords());
            properties = properties.withProperty(DocumentProperties.SUBJECT, info.getSubject());
            properties = properties.withProperty(DocumentProperties.TITLE, info.getTitle());
        }

        return properties;
    }

}
