package ru.yandex.chemodan.app.docviewer.utils;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultCDATA;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.docviewer.utils.html.HtmlPostprocessor;
import ru.yandex.chemodan.app.docviewer.web.DocviewerRequest;
import ru.yandex.chemodan.app.docviewer.web.backend.PageRequest;

/**
 * @author metal
 */
public class PageHtmlToResultSerializer {
    public static void addPageHtmlToResult(HtmlPostprocessor htmlPostprocessor, XmlSerializer xmlSerializer,
            DocviewerRequest request, String id, Element docElement, DimensionO size, Document pageHtml)
    {
        htmlPostprocessor.preprocessOutput(pageHtml, Option.of(id), size);
        String elementsPrefix = extractElementsPrefix(request);
        if (request.json) {
            Element pageStyle = docElement.addElement(elementsPrefix + "-style");
            Option<Node> styleO = getNodeByXPath(pageHtml, "/html/head/style");
            if (styleO.isPresent()) {
                pageStyle.add(new DefaultCDATA(styleO.get().getText()));
            }

            Element pageBody = docElement.addElement(elementsPrefix + "-body");
            Option<Node> bodyO = getNodeByXPath(pageHtml, "/html/body");
            if (bodyO.isPresent()) {
                Element bodyElement = (Element) bodyO.get();
                bodyElement.detach();
                Document bodyDoc = DocumentHelper.createDocument(bodyElement);
                pageBody.add(new DefaultCDATA(xmlSerializer.serializeToXml(bodyDoc)));
            }
        } else {
            Element pageHtmlElement = docElement.addElement(elementsPrefix + "-html");
            pageHtmlElement.add(pageHtml.getRootElement());
        }
    }

    private static String extractElementsPrefix(DocviewerRequest request) {
        return request instanceof PageRequest ? "page" : "doc";
    }

    private static Option<Node> getNodeByXPath(Document doc, String path) {
        return Option.ofNullable(doc.selectSingleNode(path + " | " + path.toUpperCase()));
    }
}
