package ru.yandex.chemodan.app.docviewer.utils;

import java.util.Properties;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author metal
 */
public class PropertiesHostRegexCutPrefix {
    public static void copyCutPrefix(final Properties properties) {
        Cf.x(properties)
                .keySet()
                .filter(s -> s.contains("<%") && s.contains("%>"))
                .filter(s -> getCurrentHostPrefix()
                        .matches(StringUtils.substring(s, s.indexOf("<%") + 2, s.lastIndexOf("%>.")))
                )
                .forEach(key -> {
                    String replacedKey = key.substring(key.lastIndexOf("%>.") + 3);
                    properties.setProperty(replacedKey, properties.getProperty(key));
                });
    }

    public static String getCurrentHostPrefix() {
        return StringUtils.substringBefore(HostnameUtils.localHostname(), ".");
    }
}
